<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package FeedValue
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete all plugin options.
 */
delete_option( 'feedvalue_api_key' );
delete_option( 'feedvalue_widget_settings' );
delete_option( 'feedvalue_targeting_rules' );
delete_option( 'feedvalue_cache_ttl' );

/**
 * Delete all transients (cached data).
 */
global $wpdb;

// Delete all transients with feedvalue_ prefix
$wpdb->query(
	"DELETE FROM {$wpdb->options} 
	WHERE option_name LIKE '_transient_feedvalue_%' 
	OR option_name LIKE '_transient_timeout_feedvalue_%'"
);

/**
 * Clear any cached data.
 */
wp_cache_flush();
