<?php
/**
 * Shortcode handler for [feedvalue] shortcode.
 *
 * @package FeedValue
 */

class FeedValue_Shortcode {

	/**
	 * Render shortcode.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string Shortcode output HTML.
	 */
	public function render_shortcode( $atts ) {
		$atts = shortcode_atts(
			array(
				'widget_id' => '',
			),
			$atts,
			'feedvalue'
		);

		$widget_id = sanitize_text_field( $atts['widget_id'] );

		if ( empty( $widget_id ) ) {
			if ( current_user_can( 'manage_options' ) ) {
				return '<p><strong>' . esc_html__( 'FeedValue Error:', 'feedvalue' ) . '</strong> ' . esc_html__( 'widget_id is required.', 'feedvalue' ) . '</p>';
			}
			return '';
		}

		// Check if widget should be displayed
		$widget_manager = new FeedValue_Widget_Manager();
		if ( ! $widget_manager->should_display( $widget_id ) ) {
			return '';
		}

		do_action( 'feedvalue_before_widget_render', $widget_id );

		$widget_script_url = apply_filters( 'feedvalue_widget_script_url', FEEDVALUE_WIDGET_SCRIPT_URL );

		ob_start();
		?>
		<div id="feedvalue-widget-<?php echo esc_attr( $widget_id ); ?>" class="feedvalue-widget-container"></div>
		<script>
			(function() {
				if (typeof window.FeedValue === 'undefined') {
					var script = document.createElement('script');
					script.src = '<?php echo esc_url( $widget_script_url ); ?>';
					script.async = true;
					script.setAttribute('data-widget-id', '<?php echo esc_attr( $widget_id ); ?>');
					document.head.appendChild(script);
				} else {
					window.FeedValue.init('<?php echo esc_attr( $widget_id ); ?>');
				}
			})();
		</script>
		<?php
		$output = ob_get_clean();

		do_action( 'feedvalue_after_widget_render', $widget_id );

		return $output;
	}
}
