<?php
/**
 * Plugin Name:       FeedValue - User Feedback Widgets
 * Plugin URI:        https://feedvalue.com/wordpress
 * Description:       Collect authentic user feedback with customizable widgets. Integrates seamlessly with your FeedValue dashboard.
 * Version: 0.0.12
 * Requires at least: 6.0
 * Requires PHP:      8.0
 * Author:            FeedValue
 * Author URI:        https://feedvalue.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       feedvalue
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Current plugin version.
 */
define( 'FEEDVALUE_VERSION', '0.0.12' );
define( 'FEEDVALUE_PLUGIN_FILE', __FILE__ );
define( 'FEEDVALUE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'FEEDVALUE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// API endpoint - can be overridden in wp-config.php for development:
// define( 'FEEDVALUE_API_ENDPOINT', 'http://localhost:3001' );
if ( ! defined( 'FEEDVALUE_API_ENDPOINT' ) ) {
	define( 'FEEDVALUE_API_ENDPOINT', 'https://api.feedvalue.com' );
}

// Widget script URL - can be overridden for local widget development:
// define( 'FEEDVALUE_WIDGET_SCRIPT_URL', 'http://localhost:5173/dist/widget.js' );
if ( ! defined( 'FEEDVALUE_WIDGET_SCRIPT_URL' ) ) {
	define( 'FEEDVALUE_WIDGET_SCRIPT_URL', 'https://cdn.feedvalue.com/widget.js' );
}

define( 'FEEDVALUE_CACHE_TTL', 300 ); // 5 minutes

/**
 * Filter to override API endpoint from plugin settings.
 *
 * @param string $endpoint Default API endpoint.
 * @return string The API endpoint to use.
 */
function feedvalue_filter_api_endpoint( $endpoint ) {
	$override = get_option( 'feedvalue_api_url_override', '' );
	if ( ! empty( $override ) ) {
		return $override;
	}
	return $endpoint;
}
add_filter( 'feedvalue_api_endpoint', 'feedvalue_filter_api_endpoint' );

/**
 * The code that runs during plugin activation.
 */
function feedvalue_activate() {
	require_once FEEDVALUE_PLUGIN_DIR . 'includes/class-feedvalue-activator.php';
	FeedValue_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function feedvalue_deactivate() {
	require_once FEEDVALUE_PLUGIN_DIR . 'includes/class-feedvalue-deactivator.php';
	FeedValue_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'feedvalue_activate' );
register_deactivation_hook( __FILE__, 'feedvalue_deactivate' );

/**
 * The core plugin class.
 */
require FEEDVALUE_PLUGIN_DIR . 'includes/class-feedvalue.php';

/**
 * Begins execution of the plugin.
 */
function feedvalue_run() {
	$plugin = new FeedValue();
	$plugin->run();
}
feedvalue_run();
