#!/bin/bash

# FeedValue WordPress Plugin Build Script
# Creates a production-ready plugin ZIP bundle for distribution

set -e

PLUGIN_SLUG="feedvalue"
PLUGIN_VERSION="1.0.0"
BUILD_DIR="./build"
PLUGIN_DIR="$BUILD_DIR/$PLUGIN_SLUG"

echo "Building FeedValue WordPress Plugin v$PLUGIN_VERSION..."

# Clean build directory
echo "Cleaning build directory..."
rm -rf "$BUILD_DIR"
mkdir -p "$PLUGIN_DIR"

# Copy plugin files
echo "Copying plugin files..."
rsync -av --exclude-from='.gitignore' \
	--exclude='.git' \
	--exclude='.github' \
	--exclude='build' \
	--exclude='build.sh' \
	--exclude='node_modules' \
	--exclude='package.json' \
	--exclude='package-lock.json' \
	--exclude='.editorconfig' \
	--exclude='blocks/src' \
	--exclude='blocks/node_modules' \
	--exclude='blocks/package.json' \
	--exclude='blocks/package-lock.json' \
	. "$PLUGIN_DIR/"

# Build Gutenberg blocks
echo "Building Gutenberg blocks..."
cd blocks
npm install
npm run build
cd ..

# Copy built blocks
echo "Copying built blocks..."
mkdir -p "$PLUGIN_DIR/blocks/build"
cp -r blocks/build/* "$PLUGIN_DIR/blocks/build/"

# Create ZIP bundle
echo "Creating ZIP bundle..."
cd "$BUILD_DIR"
zip -r "../${PLUGIN_SLUG}-${PLUGIN_VERSION}.zip" "$PLUGIN_SLUG"
cd ..

# Create latest version symlink
ln -sf "${PLUGIN_SLUG}-${PLUGIN_VERSION}.zip" "${PLUGIN_SLUG}-wordpress.zip"

echo "Build complete!"
echo "Bundle created: ${PLUGIN_SLUG}-${PLUGIN_VERSION}.zip"
echo "Latest symlink: ${PLUGIN_SLUG}-wordpress.zip"
echo ""
echo "You can now:"
echo "1. Upload to WordPress.org: ${PLUGIN_SLUG}-${PLUGIN_VERSION}.zip"
echo "2. Deploy to CDN: ${PLUGIN_SLUG}-wordpress.zip"
echo "3. Test locally: Unzip and copy to wp-content/plugins/"
