<?php
/**
 * Help and Documentation admin page template.
 *
 * @package FeedValue
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap feedvalue-admin feedvalue-help-page">
	<!-- Branded Header -->
	<header class="feedvalue-header">
		<div class="feedvalue-brand">
			<div class="feedvalue-logo">
				<img src="<?php echo esc_url( FEEDVALUE_PLUGIN_URL . 'admin/images/feedvalue-icon.png' ); ?>" alt="<?php esc_attr_e( 'FeedValue', 'feedvalue' ); ?>" width="40" height="40" />
			</div>
			<div class="feedvalue-title-group">
				<h1 class="feedvalue-title"><?php esc_html_e( 'FeedValue', 'feedvalue' ); ?></h1>
				<span class="feedvalue-subtitle"><?php esc_html_e( 'Help & Documentation', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-header-actions">
			<a href="https://feedvalue.com/docs" target="_blank" rel="noopener noreferrer" class="button">
				<span class="dashicons dashicons-external"></span>
				<?php esc_html_e( 'Online Docs', 'feedvalue' ); ?>
			</a>
		</div>
	</header>

	<!-- Help Cards Grid -->
	<div class="feedvalue-help-grid">
		<!-- Getting Started -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-welcome-learn-more"></span>
					</span>
					<?php esc_html_e( 'Getting Started', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<ol>
					<li>
						<strong><?php esc_html_e( 'Get your API Key', 'feedvalue' ); ?></strong><br>
						<?php
						printf(
							/* translators: %s: FeedValue dashboard URL */
							esc_html__( 'Sign up or log in to your %s to get your API key.', 'feedvalue' ),
							'<a href="https://feedvalue.com/app" target="_blank" rel="noopener noreferrer">FeedValue Dashboard</a>'
						);
						?>
					</li>
					<li>
						<strong><?php esc_html_e( 'Configure the plugin', 'feedvalue' ); ?></strong><br>
						<?php
						printf(
							/* translators: %s: Settings page URL */
							esc_html__( 'Go to %s and enter your API key.', 'feedvalue' ),
							'<a href="' . esc_url( admin_url( 'admin.php?page=feedvalue-settings' ) ) . '">' . esc_html__( 'Settings', 'feedvalue' ) . '</a>'
						);
						?>
					</li>
					<li>
						<strong><?php esc_html_e( 'Create widgets', 'feedvalue' ); ?></strong><br>
						<?php esc_html_e( 'Create feedback widgets in your FeedValue dashboard, then refresh widgets in WordPress.', 'feedvalue' ); ?>
					</li>
					<li>
						<strong><?php esc_html_e( 'Enable and display', 'feedvalue' ); ?></strong><br>
						<?php esc_html_e( 'Enable widgets and configure targeting rules to control where they appear.', 'feedvalue' ); ?>
					</li>
				</ol>
			</div>
		</div>

		<!-- Embedding Widgets -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-embed-generic"></span>
					</span>
					<?php esc_html_e( 'Embedding Widgets', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<h3><?php esc_html_e( 'Shortcode', 'feedvalue' ); ?></h3>
				<p><?php esc_html_e( 'Use the shortcode to embed a specific widget:', 'feedvalue' ); ?></p>
				<code class="feedvalue-code-block">[feedvalue widget_id="your-widget-id"]</code>

				<h3><?php esc_html_e( 'Gutenberg Block', 'feedvalue' ); ?></h3>
				<p><?php esc_html_e( 'In the block editor, search for "FeedValue" and add the FeedValue Widget block. Select your widget from the dropdown.', 'feedvalue' ); ?></p>

				<h3><?php esc_html_e( 'Global Display (Header/Footer)', 'feedvalue' ); ?></h3>
				<p><?php esc_html_e( 'In the widget settings, set "Global Position" to Header or Footer to display the widget site-wide.', 'feedvalue' ); ?></p>
			</div>
		</div>

		<!-- Targeting Rules -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-filter"></span>
					</span>
					<?php esc_html_e( 'Targeting Rules', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<p><?php esc_html_e( 'Control where widgets appear using inclusion and exclusion rules:', 'feedvalue' ); ?></p>

				<h3><?php esc_html_e( 'Available Rule Types', 'feedvalue' ); ?></h3>
				<ul>
					<li><strong><?php esc_html_e( 'All Pages', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Show on every page', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Homepage', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Only on the front page', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Post Type', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Specific post types (posts, pages, custom)', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Post IDs', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Specific posts by ID (comma-separated)', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Categories', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Posts in specific categories', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Tags', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Posts with specific tags', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Archives', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'All archive pages', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'Search Results', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Search results page', 'feedvalue' ); ?></li>
					<li><strong><?php esc_html_e( 'URL Pattern', 'feedvalue' ); ?></strong> - <?php esc_html_e( 'Match URLs with regex pattern', 'feedvalue' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Rule Logic', 'feedvalue' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Inclusion rules use OR logic (any match shows widget)', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Exclusion rules override inclusion rules', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'No rules = show everywhere', 'feedvalue' ); ?></li>
				</ul>
			</div>
		</div>

		<!-- Troubleshooting -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-sos"></span>
					</span>
					<?php esc_html_e( 'Troubleshooting', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<h3><?php esc_html_e( 'Widget not appearing?', 'feedvalue' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Verify the widget is enabled in Settings', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Check targeting rules match the current page', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Clear your browser cache and any caching plugins', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Use "Clear Cache" in plugin settings', 'feedvalue' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Connection errors?', 'feedvalue' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Verify your API key is correct', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Check your server can reach api.feedvalue.com', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Ensure your hosting firewall allows outbound HTTPS', 'feedvalue' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Performance issues?', 'feedvalue' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Widget scripts load asynchronously and should not block page rendering', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'API responses are cached for 5 minutes by default', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Adjust cache TTL in Settings if needed', 'feedvalue' ); ?></li>
				</ul>
			</div>
		</div>

		<!-- Privacy & GDPR -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-shield"></span>
					</span>
					<?php esc_html_e( 'Privacy & GDPR', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<p><?php esc_html_e( 'FeedValue is designed with privacy in mind:', 'feedvalue' ); ?></p>
				<ul>
					<li><?php esc_html_e( 'Feedback is stored on FeedValue servers, not in WordPress', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Plugin integrates with WordPress Privacy Policy page', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Supports WordPress data export and erasure requests', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'No personal data stored in WordPress database', 'feedvalue' ); ?></li>
				</ul>

				<p>
					<?php
					printf(
						/* translators: %s: FeedValue privacy policy URL */
						esc_html__( 'For detailed privacy information, see the %s.', 'feedvalue' ),
						'<a href="https://feedvalue.com/privacy" target="_blank" rel="noopener noreferrer">' . esc_html__( 'FeedValue Privacy Policy', 'feedvalue' ) . '</a>'
					);
					?>
				</p>

				<p>
					<strong><?php esc_html_e( 'Data Requests:', 'feedvalue' ); ?></strong><br>
					<?php esc_html_e( 'Users can request their feedback data by contacting support@feedvalue.com', 'feedvalue' ); ?>
				</p>
			</div>
		</div>

		<!-- Support -->
		<div class="feedvalue-help-section">
			<div class="feedvalue-section-header">
				<h2>
					<span class="feedvalue-section-icon">
						<span class="dashicons dashicons-email-alt"></span>
					</span>
					<?php esc_html_e( 'Support & Resources', 'feedvalue' ); ?>
				</h2>
			</div>
			<div class="feedvalue-help-content">
				<ul class="feedvalue-links-list">
					<li>
						<span class="dashicons dashicons-admin-home"></span>
						<a href="https://feedvalue.com/app" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e( 'FeedValue Dashboard', 'feedvalue' ); ?>
						</a>
					</li>
					<li>
						<span class="dashicons dashicons-book"></span>
						<a href="https://feedvalue.com/docs" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e( 'Documentation', 'feedvalue' ); ?>
						</a>
					</li>
					<li>
						<span class="dashicons dashicons-editor-help"></span>
						<a href="https://feedvalue.com/faq" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e( 'FAQ', 'feedvalue' ); ?>
						</a>
					</li>
					<li>
						<span class="dashicons dashicons-email"></span>
						<a href="mailto:support@feedvalue.com">
							<?php esc_html_e( 'Email Support: support@feedvalue.com', 'feedvalue' ); ?>
						</a>
					</li>
				</ul>

				<div class="feedvalue-version-info">
					<p>
						<strong><?php esc_html_e( 'Plugin Version:', 'feedvalue' ); ?></strong>
						<?php echo esc_html( FEEDVALUE_VERSION ); ?>
					</p>
					<p>
						<strong><?php esc_html_e( 'WordPress Version:', 'feedvalue' ); ?></strong>
						<?php echo esc_html( get_bloginfo( 'version' ) ); ?>
					</p>
					<p>
						<strong><?php esc_html_e( 'PHP Version:', 'feedvalue' ); ?></strong>
						<?php echo esc_html( PHP_VERSION ); ?>
					</p>
				</div>
			</div>
		</div>
	</div>
</div>
