<?php
/**
 * Feedback page template.
 *
 * @package FeedValue
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

// Check if API key is configured
$encrypted_key = get_option( 'feedvalue_api_key', '' );
$is_configured = ! empty( $encrypted_key );
?>

<div class="wrap feedvalue-admin feedvalue-feedback-page">
	<!-- Branded Header -->
	<header class="feedvalue-header">
		<div class="feedvalue-brand">
			<div class="feedvalue-logo">
				<img src="<?php echo esc_url( FEEDVALUE_PLUGIN_URL . 'admin/images/feedvalue-icon.png' ); ?>" alt="<?php esc_attr_e( 'FeedValue', 'feedvalue' ); ?>" width="40" height="40" />
			</div>
			<div class="feedvalue-title-group">
				<h1 class="feedvalue-title"><?php esc_html_e( 'FeedValue', 'feedvalue' ); ?></h1>
				<span class="feedvalue-subtitle"><?php esc_html_e( 'User Feedback Widgets', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-header-actions">
			<button type="button" class="button" id="feedvalue-export-feedback">
				<span class="dashicons dashicons-download"></span>
				<?php esc_html_e( 'Export CSV', 'feedvalue' ); ?>
			</button>
		</div>
	</header>

	<!-- Stats Cards -->
	<div class="feedvalue-stats-grid">
		<div class="feedvalue-stat-card">
			<div class="feedvalue-stat-icon">
				<span class="dashicons dashicons-format-chat"></span>
			</div>
			<div class="feedvalue-stat-content">
				<span class="feedvalue-stat-value">0</span>
				<span class="feedvalue-stat-label"><?php esc_html_e( 'Total Feedback', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-stat-card feedvalue-stat-highlight">
			<div class="feedvalue-stat-icon">
				<span class="dashicons dashicons-bell"></span>
			</div>
			<div class="feedvalue-stat-content">
				<span class="feedvalue-stat-value">0</span>
				<span class="feedvalue-stat-label"><?php esc_html_e( 'Needs Review', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-stat-card">
			<div class="feedvalue-stat-icon">
				<span class="dashicons dashicons-star-filled"></span>
			</div>
			<div class="feedvalue-stat-content">
				<span class="feedvalue-stat-value">0.0</span>
				<span class="feedvalue-stat-label"><?php esc_html_e( 'Avg. Rating', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-stat-card">
			<div class="feedvalue-stat-icon">
				<span class="dashicons dashicons-calendar-alt"></span>
			</div>
			<div class="feedvalue-stat-content">
				<span class="feedvalue-stat-value">0</span>
				<span class="feedvalue-stat-label"><?php esc_html_e( 'This Week', 'feedvalue' ); ?></span>
			</div>
		</div>
	</div>

	<!-- Feedback Table Section -->
	<div class="feedvalue-feedback-section">
		<div class="feedvalue-section-header">
			<h2>
				<span class="feedvalue-section-icon">
					<span class="dashicons dashicons-list-view"></span>
				</span>
				<?php esc_html_e( 'All Feedback', 'feedvalue' ); ?>
			</h2>
		</div>

		<!-- Filters -->
		<div class="feedvalue-filters">
			<div class="feedvalue-filter-group">
				<label for="feedvalue-filter-widget" class="screen-reader-text"><?php esc_html_e( 'Filter by widget', 'feedvalue' ); ?></label>
				<select id="feedvalue-filter-widget" class="feedvalue-filter-select">
					<option value=""><?php esc_html_e( 'All Widgets', 'feedvalue' ); ?></option>
				</select>
			</div>
			<div class="feedvalue-filter-group">
				<label for="feedvalue-filter-status" class="screen-reader-text"><?php esc_html_e( 'Filter by status', 'feedvalue' ); ?></label>
				<select id="feedvalue-filter-status" class="feedvalue-filter-select">
					<option value=""><?php esc_html_e( 'All Statuses', 'feedvalue' ); ?></option>
					<option value="new"><?php esc_html_e( 'New', 'feedvalue' ); ?></option>
					<option value="read"><?php esc_html_e( 'Read', 'feedvalue' ); ?></option>
					<option value="resolved"><?php esc_html_e( 'Resolved', 'feedvalue' ); ?></option>
					<option value="archived"><?php esc_html_e( 'Archived', 'feedvalue' ); ?></option>
				</select>
			</div>
			<div class="feedvalue-filter-group">
				<label for="feedvalue-filter-rating" class="screen-reader-text"><?php esc_html_e( 'Filter by rating', 'feedvalue' ); ?></label>
				<select id="feedvalue-filter-rating" class="feedvalue-filter-select">
					<option value=""><?php esc_html_e( 'All Ratings', 'feedvalue' ); ?></option>
					<option value="5">&#9733;&#9733;&#9733;&#9733;&#9733; (5)</option>
					<option value="4">&#9733;&#9733;&#9733;&#9733;&#9734; (4+)</option>
					<option value="3">&#9733;&#9733;&#9733;&#9734;&#9734; (3+)</option>
					<option value="2">&#9733;&#9733;&#9734;&#9734;&#9734; (2+)</option>
					<option value="1">&#9733;&#9734;&#9734;&#9734;&#9734; (1+)</option>
				</select>
			</div>
			<div class="feedvalue-filter-group feedvalue-search-group">
				<label for="feedvalue-search" class="screen-reader-text"><?php esc_html_e( 'Search feedback', 'feedvalue' ); ?></label>
				<input type="search" id="feedvalue-search" class="feedvalue-search-input" placeholder="<?php esc_attr_e( 'Search feedback...', 'feedvalue' ); ?>" />
				<span class="dashicons dashicons-search feedvalue-search-icon"></span>
			</div>
		</div>

		<!-- Bulk Actions -->
		<div class="feedvalue-bulk-actions">
			<label for="feedvalue-bulk-action" class="screen-reader-text"><?php esc_html_e( 'Bulk actions', 'feedvalue' ); ?></label>
			<select id="feedvalue-bulk-action" class="feedvalue-filter-select">
				<option value=""><?php esc_html_e( 'Bulk Actions', 'feedvalue' ); ?></option>
				<option value="read"><?php esc_html_e( 'Mark as Read', 'feedvalue' ); ?></option>
				<option value="resolved"><?php esc_html_e( 'Mark Resolved', 'feedvalue' ); ?></option>
				<option value="archived"><?php esc_html_e( 'Archive', 'feedvalue' ); ?></option>
				<option value="delete"><?php esc_html_e( 'Delete', 'feedvalue' ); ?></option>
			</select>
			<button type="button" class="button" id="feedvalue-apply-bulk"><?php esc_html_e( 'Apply', 'feedvalue' ); ?></button>
			<span class="feedvalue-selected-count" style="display: none;"></span>
		</div>

		<!-- Feedback Table -->
		<table class="feedvalue-widget-table feedvalue-feedback-table">
			<thead>
				<tr>
					<th class="feedvalue-col-checkbox">
						<input type="checkbox" id="feedvalue-select-all" />
					</th>
					<th class="feedvalue-col-date"><?php esc_html_e( 'Date', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-widget"><?php esc_html_e( 'Widget', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-rating"><?php esc_html_e( 'Rating', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-feedback"><?php esc_html_e( 'Feedback', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-user"><?php esc_html_e( 'User', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-status"><?php esc_html_e( 'Status', 'feedvalue' ); ?></th>
					<th class="feedvalue-col-actions"><?php esc_html_e( 'Actions', 'feedvalue' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<!-- Feedback rows will be populated via JavaScript -->
			</tbody>
		</table>

		<!-- Pagination -->
		<div class="feedvalue-pagination">
			<div class="feedvalue-pagination-info">
				<?php esc_html_e( 'Loading...', 'feedvalue' ); ?>
			</div>
			<div class="feedvalue-pagination-controls">
				<button type="button" class="button feedvalue-page-btn" disabled>
					<span class="dashicons dashicons-arrow-left-alt2"></span>
				</button>
				<span class="feedvalue-page-numbers">
					<button type="button" class="button feedvalue-page-btn feedvalue-page-active">1</button>
				</span>
				<button type="button" class="button feedvalue-page-btn" disabled>
					<span class="dashicons dashicons-arrow-right-alt2"></span>
				</button>
			</div>
		</div>
	</div>

	<?php if ( ! $is_configured ) : ?>
	<!-- Not Configured Notice -->
	<div class="feedvalue-notice feedvalue-notice-info">
		<span class="dashicons dashicons-info"></span>
		<p>
			<?php
			printf(
				/* translators: %s: settings page link */
				esc_html__( 'Please configure your API key in %s to view and manage feedback.', 'feedvalue' ),
				'<a href="' . esc_url( admin_url( 'admin.php?page=feedvalue-settings' ) ) . '">' . esc_html__( 'Settings', 'feedvalue' ) . '</a>'
			);
			?>
		</p>
	</div>
	<?php endif; ?>
</div>

<style>
/* Toast notifications */
.feedvalue-toast {
	position: fixed;
	top: 50px;
	right: 20px;
	background: #fff;
	padding: 12px 20px;
	border-radius: 6px;
	box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
	display: flex;
	align-items: center;
	gap: 10px;
	z-index: 100000;
	transform: translateX(120%);
	transition: transform 0.3s ease;
}

.feedvalue-toast.visible {
	transform: translateX(0);
}

.feedvalue-toast-success {
	border-left: 4px solid #46b450;
}

.feedvalue-toast-success .dashicons {
	color: #46b450;
}

.feedvalue-toast-error {
	border-left: 4px solid #dc3232;
}

.feedvalue-toast-error .dashicons {
	color: #dc3232;
}

/* Loading state */
.feedvalue-loading-state td,
.feedvalue-empty-state td {
	padding: 60px 20px !important;
	text-align: center;
}

.feedvalue-loading-content,
.feedvalue-empty-content {
	display: flex;
	flex-direction: column;
	align-items: center;
	gap: 10px;
}

.feedvalue-loading-content .spinner {
	float: none;
	margin: 0;
}

.feedvalue-empty-content .dashicons {
	font-size: 48px;
	width: 48px;
	height: 48px;
	color: #ccc;
}

.feedvalue-empty-content h3 {
	margin: 10px 0 5px;
	color: #23282d;
}

.feedvalue-empty-content p {
	color: #666;
	margin: 0;
}

/* Badge for resolved status */
.feedvalue-badge-resolved {
	background-color: #46b450;
	color: #fff;
}
</style>
