<?php
/**
 * Main admin page template.
 *
 * @package FeedValue
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
?>

<div class="wrap feedvalue-admin">
	<!-- Branded Header -->
	<header class="feedvalue-header">
		<div class="feedvalue-brand">
			<div class="feedvalue-logo">
				<img src="<?php echo esc_url( FEEDVALUE_PLUGIN_URL . 'admin/images/feedvalue-icon.png' ); ?>" alt="<?php esc_attr_e( 'FeedValue', 'feedvalue' ); ?>" width="40" height="40" />
			</div>
			<div class="feedvalue-title-group">
				<h1 class="feedvalue-title"><?php esc_html_e( 'FeedValue', 'feedvalue' ); ?></h1>
				<span class="feedvalue-subtitle"><?php esc_html_e( 'User Feedback Widgets', 'feedvalue' ); ?></span>
			</div>
		</div>
		<div class="feedvalue-header-actions">
			<span class="feedvalue-version">v<?php echo esc_html( FEEDVALUE_VERSION ); ?></span>
			<button type="button" id="feedvalue-clear-cache" class="button feedvalue-clear-cache-btn">
				<span class="dashicons dashicons-trash"></span>
				<?php esc_html_e( 'Clear Cache', 'feedvalue' ); ?>
			</button>
		</div>
	</header>

	<?php settings_errors(); ?>

	<div class="feedvalue-admin-container">
		<div class="feedvalue-main-content">
			<?php require_once FEEDVALUE_PLUGIN_DIR . 'admin/partials/feedvalue-settings-display.php'; ?>
			<?php require_once FEEDVALUE_PLUGIN_DIR . 'admin/partials/feedvalue-widget-list.php'; ?>
		</div>

		<div class="feedvalue-sidebar">
			<div class="feedvalue-card">
				<h3><?php esc_html_e( 'Quick Start', 'feedvalue' ); ?></h3>
				<ol>
					<li><?php esc_html_e( 'Enter your API key and test connection', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Enable your widgets below', 'feedvalue' ); ?></li>
					<li><?php esc_html_e( 'Click shortcode to copy, paste where needed', 'feedvalue' ); ?></li>
				</ol>
				<p style="margin-top: 12px; font-size: 13px; color: var(--fv-text-muted);">
					<?php esc_html_e( 'Widget appearance is configured in your FeedValue dashboard.', 'feedvalue' ); ?>
				</p>
			</div>

			<div class="feedvalue-card">
				<h3><?php esc_html_e( 'Documentation', 'feedvalue' ); ?></h3>
				<ul>
					<li><a href="https://feedvalue.com/docs" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Plugin Documentation', 'feedvalue' ); ?></a></li>
					<li><a href="https://feedvalue.com/docs/wordpress" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'WordPress Guide', 'feedvalue' ); ?></a></li>
					<li><a href="https://feedvalue.com/support" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Support', 'feedvalue' ); ?></a></li>
				</ul>
			</div>

			<div class="feedvalue-card">
				<h3><?php esc_html_e( 'Need Help?', 'feedvalue' ); ?></h3>
				<p><?php esc_html_e( 'Contact our support team at:', 'feedvalue' ); ?></p>
				<p><a href="mailto:support@feedvalue.com">support@feedvalue.com</a></p>
			</div>
		</div>
	</div>
</div>
