# FeedValue WordPress Plugin

![FeedValue Logo](https://feedvalue.com/assets/logo.png)

**Collect authentic user feedback with customizable widgets. Integrates seamlessly with your FeedValue dashboard.**

[![WordPress Plugin Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](https://github.com/sarverenterprises/feedvalue-wordpress-plugin)
[![WordPress Compatibility](https://img.shields.io/badge/wordpress-6.0%2B-blue.svg)](https://wordpress.org/)
[![PHP Compatibility](https://img.shields.io/badge/php-8.0%2B-blue.svg)](https://www.php.net/)
[![License](https://img.shields.io/badge/license-GPL--2.0%2B-blue.svg)](LICENSE)

## Features

- **Zero-Code Integration**: Install, configure API key, and start collecting feedback—no theme modifications required
- **Flexible Display Methods**: Use shortcodes, Gutenberg blocks, or global site-wide widgets
- **Advanced Targeting**: Show widgets on specific pages, post types, categories, or site-wide with inclusion/exclusion rules
- **Performance Optimized**: Conditional script loading and 5-minute widget config caching
- **GDPR Compliant**: No local user data storage, complete uninstall cleanup
- **WordPress Best Practices**: Follows WordPress coding standards, security guidelines, and accessibility standards

## Installation

### From GitHub (Development)

1. Clone this repository into your WordPress plugins directory:
   ```bash
   cd /path/to/wordpress/wp-content/plugins/
   git clone https://github.com/sarverenterprises/feedvalue-wordpress-plugin.git feedvalue
   cd feedvalue
   ```

2. Install dependencies (optional, only needed for Gutenberg block development):
   ```bash
   cd blocks
   npm install
   npm run build
   cd ..
   ```

3. Activate the plugin in WordPress admin:
   - Navigate to **Plugins** in WordPress admin
   - Find "FeedValue - User Feedback Widgets"
   - Click **Activate**

### From WordPress.org (Future)

1. In WordPress admin, go to **Plugins → Add New**
2. Search for "FeedValue"
3. Click **Install Now** and then **Activate**

## Quick Start

### 1. Get Your FeedValue API Key

1. Sign up at [feedvalue.com](https://feedvalue.com) (if you haven't already)
2. Create a new app in your [FeedValue dashboard](https://feedvalue.com/app)
3. Copy your API key from **App Settings**

### 2. Configure the Plugin

1. In WordPress admin, go to **Settings → FeedValue**
2. Paste your API key into the **FeedValue API Key** field
3. Click **Save Settings**

The plugin will automatically fetch your widgets from FeedValue.

### 3. Add Widgets to Your Site

**Option A: Using Shortcodes**

Copy the shortcode from the widget list and paste it into any post or page:

```
[feedvalue widget_id="abc123def456"]
```

**Option B: Using Gutenberg Blocks**

1. In the block editor, click **+** to add a new block
2. Search for "FeedValue Widget"
3. Select the widget from the dropdown
4. Publish or update your post/page

**Option C: Global Site-Wide Widgets**

1. In **Settings → FeedValue**, find the widget you want to display globally
2. Choose a **Global Position**: Header, Footer, Before Content, or After Content
3. Configure targeting rules (optional)
4. Click **Save Settings**

## Usage

### Shortcodes

Basic shortcode syntax:

```
[feedvalue widget_id="your_widget_id_here"]
```

**Where to use shortcodes:**
- Posts and pages (content editor)
- Text widgets in sidebars/footers
- Custom post types
- Page builders (Elementor, Divi, Beaver Builder, etc.)

### Gutenberg Blocks

1. Add the **FeedValue Widget** block to your post/page
2. Select a widget from the dropdown in the block settings sidebar
3. The widget will appear when the page is published

### Targeting Rules

Control where widgets appear using targeting rules:

**Inclusion Rules** (where to show):
- All pages
- Homepage only
- Specific post types (posts, pages, custom post types)
- Specific post/page IDs (comma-separated)
- Categories and tags
- Archive pages
- Search results

**Exclusion Rules** (where NOT to show):
- Same options as inclusion rules
- Exclusion overrides inclusion

**Example**: Show on all blog posts except the "News" category:
- **Inclusion**: Post Type = Posts
- **Exclusion**: Category = News

### API Key Management

Your API key is encrypted before being stored in the WordPress database using WordPress salts. To update your API key:

1. Go to **Settings → FeedValue**
2. Clear the API key field (delete the dots)
3. Enter your new API key
4. Click **Save Settings**

### Cache Management

Widget configuration is cached for 5 minutes by default. To clear the cache:

1. Go to **Settings → FeedValue**
2. Click **Clear Cache Now**

Or configure a custom cache duration in the **Cache Duration** field.

## Troubleshooting

### Widget Not Appearing

1. **Check API Key**: Ensure your API key is valid in **Settings → FeedValue**
2. **Check Targeting Rules**: Verify targeting rules include the page you're testing
3. **Clear Cache**: Click **Clear Cache** in plugin settings
4. **Clear Browser Cache**: Hard refresh with `Cmd+Shift+R` (Mac) or `Ctrl+Shift+R` (Windows)
5. **Check Browser Console**: Open DevTools (F12) and look for JavaScript errors

### Invalid API Key Error

1. Copy the API key again from [FeedValue dashboard](https://feedvalue.com/app)
2. Ensure no extra spaces before/after the API key
3. Verify your FeedValue account email is verified

### Widget Config Not Updating

1. Wait 5 minutes (cache TTL)
2. Click **Clear Cache** in **Settings → FeedValue**
3. Hard refresh your browser

## Development

### Prerequisites

- PHP 8.0 or higher
- WordPress 6.0 or higher
- Node.js 16+ and npm (for Gutenberg block development)

### Local Setup

```bash
# Clone repository
cd /path/to/wordpress/wp-content/plugins/
git clone https://github.com/sarverenterprises/feedvalue-wordpress-plugin.git feedvalue
cd feedvalue

# Install JavaScript dependencies (for blocks)
cd blocks
npm install

# Build Gutenberg blocks
npm run build  # Production build
npm run start  # Development build with watch mode
```

### File Structure

```
feedvalue/
├── feedvalue.php                 # Main plugin file
├── uninstall.php                 # Uninstall cleanup
├── includes/                     # Core plugin classes
├── admin/                        # Admin area functionality
├── public/                       # Public-facing functionality
├── blocks/                       # Gutenberg block source
└── languages/                    # Translation files
```

### Coding Standards

Follow [WordPress Coding Standards](https://developer.wordpress.org/coding-standards/):

```bash
# Install PHP_CodeSniffer with WordPress standards
composer require --dev squizlabs/php_codesniffer
composer require --dev wp-coding-standards/wpcs

# Run code sniffer
./vendor/bin/phpcs --standard=WordPress .
```

## Security

This plugin follows WordPress security best practices:

- Nonce verification on all form submissions
- Capability checks (`manage_options` required for admin actions)
- Input sanitization (`sanitize_text_field()`, `esc_url()`)
- Output escaping (`esc_html()`, `esc_attr()`)
- API key encryption using WordPress salts
- Prepared SQL statements (WordPress $wpdb)
- CSRF protection via WordPress nonces

**Reporting Security Issues**: Please report security vulnerabilities to security@feedvalue.com.

## GDPR Compliance

### Data Stored by Plugin

**WordPress Database:**
- FeedValue API key (encrypted)
- Widget enable/disable state
- Targeting rules configuration

**WordPress Transients (temporary cache):**
- Widget list (5-minute TTL)
- Widget configuration (5-minute TTL)

**No User Data Stored:**
- Plugin does NOT store user feedback submissions
- Plugin does NOT store user IP addresses
- Plugin does NOT set cookies (widget.js may set session cookies)

### Uninstall Cleanup

When the plugin is uninstalled:
1. All plugin options deleted from database
2. All transient caches cleared
3. No orphaned data remains

## Support

- **Documentation**: [feedvalue.com/docs/wordpress](https://feedvalue.com/docs/wordpress)
- **Email Support**: support@feedvalue.com
- **GitHub Issues**: [github.com/sarverenterprises/feedvalue-wordpress-plugin/issues](https://github.com/sarverenterprises/feedvalue-wordpress-plugin/issues)

## Contributing

Contributions are welcome! Please follow these guidelines:

1. Fork the repository
2. Create a feature branch: `git checkout -b feature/your-feature-name`
3. Follow WordPress coding standards
4. Add tests for new features
5. Update documentation
6. Submit a pull request

## Changelog

### Version 1.0.0 (2025-01-XX)

**Features:**
- Global API key management
- Auto-fetch widget list with 5-minute cache
- Shortcode support: `[feedvalue widget_id="xxx"]`
- Gutenberg block support
- Global site-wide widget insertion
- Flexible targeting rules (inclusion + exclusion)
- Manual cache refresh
- WordPress debug.log integration
- GDPR compliance with uninstall cleanup

**Known Limitations:**
- Single FeedValue app per WordPress site
- No multisite support (planned for future release)

## License

This plugin is licensed under the GPL-2.0+. See [LICENSE](LICENSE) file for details.

```
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
```

## Credits

**Developed by**: [Sarver Enterprises](https://sarverenterprises.com)
**Website**: [feedvalue.com](https://feedvalue.com)
**GitHub**: [github.com/sarverenterprises](https://github.com/sarverenterprises)

---

Made with care by the FeedValue team
